% k-Wave Toolbox
% Version B.0.3
% Released: 15th February 2011
% Authors: Bradley Treeby and Ben Cox    
%
% See k-Wave Toolbox in help menu for description and examples.
% Type "help <command-name>" for documentation on individual commands.
% -----------------------------------------------------------------
%
% Wave Propagation
%   kspaceFirstOrder1D  - 1D time-domain simulation of wave propagation
%   kspaceFirstOrder2D  - 2D time-domain simulation of wave propagation
%   kspaceFirstOrder3D  - 3D time-domain simulation of wave propagation
%   kspaceSecondOrder   - Fast time-domain simulation of wave propagation for homogeneous media
% 
% Image Reconstruction
%   kspaceLineRecon     - 2D linear FFT reconstruction
%   kspacePlaneRecon    - 3D planar FFT reconstruction
% 
% Geometry Creation
%   makeBall            - Create a binary map of filled ball within a 3D grid
%   makeCartCircle      - Create a 2D Cartesian circle or arc
%   makeCartSphere      - Create a 3D Cartesian sphere
%   makeCircle          - Create a binary map of a circle within a 2D grid
%   makeDisc            - Create a binary map of a filled disc within a 2D grid
%   makeSphere          - Create a binary map of a sphere within a 3D grid
% 
% Absorption
%   attenuationWater 	- Calculate ultrasound attenuation in distilled water
%   db2neper            - Convert decibels to nepers
%   neper2db            - Convert nepers to decibels
%   powerLawKramersKronig - Calculate dispersion for power law absorption
% 
% Grid Utilities
%   cart2grid           - Interpolate a set of Cartesian points onto a binary grid
%   expandMatrix        - Enlarge a matrix by extending the edge values
%   grid2cart           - Return the Cartesian coordinates of the non-zero points of a binary grid
%   interpCartData      - Interpolate data from a Cartesian to a binary sensor mask
%   interpftn           - Resample data using Fourier interpolation
%   loadImage           - Load an image file
%   makeGrid            - Create k-space grid structure
%   numDim              - Return the number of matrix dimensions
%   resize              - Resize a matrix
%   unmaskSensorData 	- Reorder data recorded using a binary sensor mask
%   voxelPlot           - 3D plot of voxels in a binary matrix
% 
% Filtering and Spectral Utilities
%   applyFilter         - Filter input with low, high, or band pass filter
%   filterTimeSeries 	- Filter signal using the Kaiser windowing method
%   getAlphaFilter      - Create filter for medium.alpha_filter
%   getWin              - Return a frequency domain windowing function
%   spectrum            - Compute the single sided amplitude and phase spectrums
%   smooth              - Smooth a matrix
%
% Other Utilities
%   addNoise            - Add Gaussian noise to a signal for a given SNR
%   benchmark           - Run performance benchmark
%   flyThrough          - Display a three-dimensional matrix slice by slice
%   fwhm                - Compute the full width at half maximum
%   gaussian            - Create a Gaussian distribution
%   getColorMap         - Return default k-Wave color map
%   getDateString       - Create a string of the current date and time
%   getkWavePath        - Return pathname to the k-Wave Toolbox
%   makeTime            - Create an evenly spaced array of time points
%   saveTiffStack       - Save volume data as a tiff stack
%   scaleSI             - Scale a number to nearest SI unit prefix
%   scaleTime           - Convert seconds to hours, minutes, and seconds
%   speedSoundWater 	- Calculate the speed of sound in water with temperature
%   toneBurst           - Create an enveloped single frequency tone burst